<?php

require_once __DIR__ . '/../init_cloud.php';

$response = [
    'data'   => [],
    'status' => 'failed'
];

http_response_code(422);

$inputRules = [
    "from_firstname" => ["required" => true, "validate" => ["filter" => FILTER_SANITIZE_FULL_SPECIAL_CHARS]],
    "from_lastname" => ["required" => true, "validate" => ["filter" => FILTER_SANITIZE_FULL_SPECIAL_CHARS]],
    "from_email" => ["required" => true, "validate" => ["filter" => FILTER_SANITIZE_FULL_SPECIAL_CHARS]],
    "from_phone" => ["required" => true, "validate" => ["filter" => FILTER_SANITIZE_FULL_SPECIAL_CHARS]],
    "from_address" => ["required" => true, "validate" => ["filter" => FILTER_SANITIZE_FULL_SPECIAL_CHARS]],
    "from_zipcode" => ["required" => true, "validate" => ["filter" => FILTER_SANITIZE_FULL_SPECIAL_CHARS]],
    "from_city" => ["required" => true, "validate" => ["filter" => FILTER_SANITIZE_FULL_SPECIAL_CHARS]],
    "from_state" => ["required" => true, "validate" => ["filter" => FILTER_SANITIZE_FULL_SPECIAL_CHARS]],
    "from_country" => ["required" => true, "validate" => ["filter" => FILTER_SANITIZE_FULL_SPECIAL_CHARS]],

    "to_firstname" => ["required" => true, "validate" => ["filter" => FILTER_SANITIZE_FULL_SPECIAL_CHARS]],
    "to_lastname" => ["required" => true, "validate" => ["filter" => FILTER_SANITIZE_FULL_SPECIAL_CHARS]],
    "to_email" => ["required" => true, "validate" => ["filter" => FILTER_SANITIZE_FULL_SPECIAL_CHARS]],
    "to_phone" => ["required" => true, "validate" => ["filter" => FILTER_SANITIZE_FULL_SPECIAL_CHARS]],
    "to_address" => ["required" => true, "validate" => ["filter" => FILTER_SANITIZE_FULL_SPECIAL_CHARS]],
    "to_zipcode" => ["required" => true, "validate" => ["filter" => FILTER_SANITIZE_FULL_SPECIAL_CHARS]],
    "to_city" => ["required" => true, "validate" => ["filter" => FILTER_SANITIZE_FULL_SPECIAL_CHARS]],
    "to_state" => ["required" => true, "validate" => ["filter" => FILTER_SANITIZE_FULL_SPECIAL_CHARS]],
    "to_country" => ["required" => true, "validate" => ["filter" => FILTER_SANITIZE_FULL_SPECIAL_CHARS]],

    "subject" => ["required" => true, "validate" => ["filter" => FILTER_SANITIZE_FULL_SPECIAL_CHARS]],
    "date" => ["required" => true, "validate" => ["filter" => FILTER_SANITIZE_FULL_SPECIAL_CHARS]],
    "note" => ["required" => false, "validate" => ["filter" => FILTER_SANITIZE_FULL_SPECIAL_CHARS]],
];

$failed = false;

$error = [];

if (__RB_validateInput($inputRules, 'shipping_upload', $error) && !empty($_POST['id'])) {
    $objCreate = [
        'files' => []
    ];

    foreach ($inputRules as $key => $val) {
        $objCreate[$key] = $_POST[$key];
    }

    $data = [
        'id' => $_POST['id'],
        'id_customer' => $_SESSION['id'],
        'data' => $objCreate
    ];

    __RB_api_cloud(__RB_API_ACTION_CLOUD_SET_SHIPPING, $data, $json);

    http_response_code(200);
    
    $response = ["status" => 'success'];

    echo json_encode($response);

    exit;

} else {
    $response = [
        'status' => 'failed',
        'errors' => $error
    ];

    echo json_encode($response);

    exit;
}