<?php

function __RB_T_name() {
    global $__RB_config;

    return $__RB_config['name'];
}

function __RB_T_statement_descriptor() {
    global $__RB_config;

    return $__RB_config['statement_descriptor'];
}

function __RB_T_status() {
    global $__RB_config;

    return $__RB_config['status'];
}

function __RB_T_company_name() {
    global $__RB_config;

    return $__RB_config['company']['name'];
}

function __RB_T_company_vat() {
    global $__RB_config;

    return $__RB_config['company']['vat'];
}

function __RB_T_company_address() {
    global $__RB_config;

    return $__RB_config['company']['address'];
}

function __RB_T_company_city() {
    global $__RB_config;

    return $__RB_config['company']['city'];
}

function __RB_T_company_zipcode() {
    global $__RB_config;

    return $__RB_config['company']['zipcode'];
}

function __RB_T_company_state() {
    global $__RB_config;

    return $__RB_config['company']['state'];
}

function __RB_T_company_country() {
    global $__RB_config;

    return strtoupper($__RB_config['company']['country']);
}

function __RB_T_contact_email() {
    global $__RB_config;

    return $__RB_config['contact']['email'];
}

function __RB_T_contact_phone() {
    global $__RB_config;

    return $__RB_config['contact']['phone'];
}

function __RB_T_support_email() {
    global $__RB_config;

    return $__RB_config['support']['email'];
}

function __RB_T_support_phone() {
    global $__RB_config;

    return $__RB_config['support']['phone'];
}

function __RB_T_currency($type, $product = 0) {
    global $__RB_config;

    if ($product > 0 && !empty($__RB_config['product'][$product])) {
        return $__RB_config['product'][$product]['currency_code'];
    }

    if (!empty($__RB_config['currency_' . $type])) {
        return $__RB_config['currency_' . $type];
    }
}

function __RB_T_subscription_amount($product = 0, $decimal = 2) {
    global $__RB_config;

    return number_format(@$__RB_config['product'][$product]['amount'] ?: $__RB_config['subscription']['amount'], $decimal, '.', '');
}

function __RB_T_subscription_signup_amount($product = 0, $decimal = 2) {
    global $__RB_config;

    return number_format(@$__RB_config['product'][$product]['signup_amount'] ?: $__RB_config['subscription']['signup_amount'], $decimal, '.', '');
}

function __RB_T_subscription_days($product = 0) {
    global $__RB_config;

    return @$__RB_config['product'][$product]['days'] ?: $__RB_config['subscription']['days'];
}

function __RB_T_subscription_trial_days($product = 0) {
    global $__RB_config;

    return @$__RB_config['product'][$product]['trial_days'] ?: $__RB_config['subscription']['trial_days'];
}

function __RB_T_subscription_signup_amount_dyn($decimal = 2) {
    $product = $_GET['product'] ?? $_GET['p'] ?? 0;
    $product = is_numeric($product) && $product >= 0 && $product <= 10 ? $product : 0;

    return __RB_T_subscription_signup_amount($product, $decimal);
}

function __RB_T_subscription_trial_days_dyn() {
    $product = $_GET['product'] ?? $_GET['p'] ?? 0;
    $product = is_numeric($product) && $product >= 0 && $product <= 10 ? $product : 0;

    return __RB_T_subscription_trial_days($product);
}

function __RB_T_subscription_amount_dyn($decimal = 2) {
    $product = $_GET['product'] ?? $_GET['p'] ?? 0;
    $product = is_numeric($product) && $product >= 0 && $product <= 10 ? $product : 0;

    return __RB_T_subscription_amount($product, $decimal);
}

function __RB_T_subscription_days_dyn() {
    $product = $_GET['product'] ?? $_GET['p'] ?? 0;
    $product = is_numeric($product) && $product >= 0 && $product <= 10 ? $product : 0;

    return __RB_T_subscription_days($product);
}

function __RB_T_product($product, $key) {
    global $__RB_config;

    if ($product >= 0 && !empty($__RB_config['product'][$product]) && !empty($__RB_config['product'][$product][$key])) {
        return $__RB_config['product'][$product][$key];
    }

    return '';
}

function __RB_T_url_base() {
    global $__RB_config;

    return $__RB_config['url']['base'];
}

function __RB_T_url_cp() {
    global $__RB_config;

    $cp = $__RB_config['url']['cp'];

    /*
    if (!empty($__RB_config['id_object_type']) && $__RB_config['id_object_type'] == 10 && __RB_API_URL == 'https://api.amazpay.cc/__api') {
        $cp = explode('.', $cp);
        $cp[0] .= '2';

        $cp = implode('.', $cp);
    }*/

    return $cp;
}

function __RB_T_url_terms() {
    global $__RB_config;

    return $__RB_config['url']['terms'];
}

function __RB_T_url_cookie() {
    global $__RB_config;

    return $__RB_config['url']['cookie'];
}

function __RB_T_url_privacy() {
    global $__RB_config;

    return $__RB_config['url']['privacy'];
}

function __RB_T_url_refund() {
    global $__RB_config;

    return $__RB_config['url']['refund'];
}

function __RB_T_difficulty($level) {
    switch ($level) {
        case 4: return 'easy';
        case 8: return 'medium';
        case 12: return 'hard';
    }
}

function __RB_T_global_text($name) {
    if (!file_exists(__DIR__ . '/../global_text/' . $name . '.php')) {
        return 'Error';

        return;
    }

    ob_start();

    if (!empty($_SESSION) && !empty($_SESSION['lng']) && in_array($_SESSION['lng'], ['de', 'es', 'fr', 'it']) && file_exists(__DIR__ . '/../global_text_' . $_SESSION['lng'] . '/' . $name . '.php')) {
        include __DIR__ . '/../global_text_' . $_SESSION['lng'] . '/' . $name . '.php';
    }
    else {
        include __DIR__ . '/../global_text/' . $name . '.php';
    }

    $content = ob_get_contents();

    ob_end_clean();

    return $content;
}

function __RB_T_pricing_plans() {
    global $__RB_config;

    $t_trial_period = 'trial period';
    $t_monthly      = 'monthly';
    $t_days         = 'days';
    $t_country      = 'Country';

    switch (@$_SESSION['lng'] ?: $__RB_config['lng']) {
        case 'de':
            $t_trial_period = 'Probezeit';
            $t_monthly      = 'monatlich';
            $t_days         = 'Tage';
            $t_country      = 'Land';
            // no break
        case 'es':
            $t_trial_period = 'período de prueba';
            $t_monthly      = 'mensualmente';
            $t_days         = 'días';
            $t_country      = 'país';
            // no break
        case 'fr':
            $t_trial_period = "Période d'essai";
            $t_monthly      = 'mensuel';
            $t_days         = 'jours';
            $t_country      = 'Pays';
            // no break
        case 'it':
            $t_trial_period = 'periodo di prova';
            $t_monthly      = 'mensilmente';
            $t_days         = 'giorni';
            $t_country      = 'paese';
    }
    /*
    Période d'essai
    Mensuel*/

    $products = $__RB_config['product'];

    usort($products, function ($item1, $item2) {
        return floatval($item1['amount']) <=> floatval($item2['amount']);
    });

    $var = '
    <table id="customers" style="width: 100%;">
        <thead>
            <th>' . $t_country . '</th>';

    foreach ($products as $product) {
        $var .= '<th>' . $product['name'] . '</th>';
    }

    $var .= '
        </thead>
        <tbody>';

    foreach ($__RB_config['prices'] as $price) {
        if ($__RB_config['lng'] != 'en-us' || $price['currency_code'] == 'USD') {
            $var .= '
                <tr>
                    <td>' . $price['name'] . '</td>';

            foreach ($products as $product) {
                if ($price['lng_code'] == $__RB_config['lng'] || $price['currency_code'] == $product['currency_code']) {
                    $var .= '
                    <td>
                        ' . ($product['signup_amount']) . ' ' . $product['currency_symbol'] . ' / ' . $product['trial_days'] . ' ' . $t_days . ' ' . $t_trial_period . '<br>
                        ' . ($product['amount']) . ' ' . $price['currency_symbol'] . ' / ' . $product['days'] . ' ' . $t_days . '
                    </td>';
                }
                else {
                    $var .= '
                    <td>
                        ' . number_format(($price['signup_amount'] / ($__RB_config['subscription']['signup_amount'] < 0 || empty($__RB_config['subscription']['signup_amount']) ? 1 : $__RB_config['subscription']['signup_amount']) * $product['signup_amount']), 2) . ' ' . $price['currency_symbol'] . ' / ' . $product['trial_days'] . ' ' . $t_days . ' ' . $t_trial_period . '<br>
                        ' . number_format(($price['price'] / ($__RB_config['subscription']['amount'] ? $__RB_config['subscription']['amount'] : 1) * $product['amount']), 2) . ' ' . $price['currency_symbol'] . ' / ' . $product['days'] . ' ' . $t_days . '
                    </td>';
                }
            }

            $var .= '
                </tr>';
        }
    }

    $var .= '
        </tbody>
    </table>';

    return $var;
}


//
function __RB_T_pricing_plans_shop() {
    global $__RB_config;

    $t_trial_period = 'access period';
    $t_monthly      = 'monthly';
    $t_days         = 'days';
    $t_country      = 'Country';

    switch (@$_SESSION['lng'] ?: $__RB_config['lng']) {
        case 'de':
            $t_trial_period = 'Zugriffszeitraum';
            $t_monthly      = 'monatlich';
            $t_days         = 'Tage';
            $t_country      = 'Land';
            // no break
        case 'es':
            $t_trial_period = 'período de acceso';
            $t_monthly      = 'mensualmente';
            $t_days         = 'días';
            $t_country      = 'país';
            // no break
        case 'fr':
            $t_trial_period = "période d'accès";
            $t_monthly      = 'mensuel';
            $t_days         = 'jours';
            $t_country      = 'Pays';
            // no break
        case 'it':
            $t_trial_period = 'periodo di accesso';
            $t_monthly      = 'mensilmente';
            $t_days         = 'giorni';
            $t_country      = 'paese';
    }

    //TEMP Remove after correct translation
    $t_trial_period = 'access period';
    $t_monthly      = 'monthly';
    $t_days         = 'days';
    $t_country      = 'Country';
    //TEMP END

    /*
    Période d'essai
    Mensuel*/

    $products = $__RB_config['product'];

    usort($products, function ($item1, $item2) {
        return floatval($item1['amount']) <=> floatval($item2['amount']);
    });

    $var = '
    <table id="customers" style="width: 100%;">
        <thead>
            <th>' . $t_country . '</th>';

    foreach ($products as $product) {
        $var .= '<th>' . $product['name'] . '</th>';
    }

    $var .= '
        </thead>
        <tbody>';

    foreach ($__RB_config['prices'] as $price) {
        if ($__RB_config['lng'] != 'en-us' || $price['currency_code'] == 'USD') {
            $var .= '
                <tr>
                    <td>' . $price['name'] . '</td>';

            foreach ($products as $product) {
                if ($price['lng_code'] == $__RB_config['lng'] || $price['currency_code'] == $product['currency_code']) {
                    $var .= '
                    <td>
                        ' . ($product['signup_amount']) . ' ' . $product['currency_symbol'] . ' / ' . $product['trial_days'] . ' ' . $t_days . ' ' . $t_trial_period . '<br>
                        ' . ($product['amount']) . ' ' . $price['currency_symbol'] . ' / ' . $product['days'] . ' ' . $t_days . '
                    </td>';
                }
                else {
                    $var .= '
                    <td>
                        ' . number_format(($price['signup_amount'] / ($__RB_config['subscription']['signup_amount'] < 0 || empty($__RB_config['subscription']['signup_amount']) ? 1 : $__RB_config['subscription']['signup_amount']) * $product['signup_amount']), 2) . ' ' . $price['currency_symbol'] . ' / ' . $product['trial_days'] . ' ' . $t_days . ' ' . $t_trial_period . '<br>
                        ' . number_format(($price['price'] / ($__RB_config['subscription']['amount'] ? $__RB_config['subscription']['amount'] : 1) * $product['amount']), 2) . ' ' . $price['currency_symbol'] . ' / ' . $product['days'] . ' ' . $t_days . '
                    </td>';
                }
            }

            $var .= '
                </tr>';
        }
    }

    $var .= '
        </tbody>
    </table>';

    return $var;
}
//


function __RB_T_customer_firstName() {
    return isset($_POST['first_name']) ? $_POST['first_name'] : (!empty($_SESSION['address']) ? $_SESSION['address']['first_name'] : '');
}

function __RB_T_customer_lastName() {
    return isset($_POST['last_name']) ? $_POST['last_name'] : (!empty($_SESSION['address']) ? $_SESSION['address']['last_name'] : '');
}

function __RB_T_customer_address() {
    return isset($_POST['address']) ? $_POST['address'] : (!empty($_SESSION['address']) ? $_SESSION['address']['address'] : '');
}

function __RB_T_customer_city() {
    return isset($_POST['city']) ? $_POST['city'] : (!empty($_SESSION['address']) ? $_SESSION['address']['city'] : '');
}

function __RB_T_customer_postalCode() {
    return isset($_POST['postal_code']) ? $_POST['postal_code'] : (!empty($_SESSION['address']) ? $_SESSION['address']['postal_code'] : '');
}

function __RB_T_customer_country() {
    return strtoupper(!empty($_SESSION['address']) ? $_SESSION['address']['postal_code'] : '');
}

function __RB_T_customer_phone() {
    return isset($_POST['phone']) ? $_POST['phone'] : (!empty($_SESSION['address']) ? $_SESSION['address']['phone'] : '');
}

function __RB_T_customer_email() {
    return isset($_POST['email']) ? $_POST['email'] : (!empty($_SESSION['address']) ? $_SESSION['address']['email'] : '');
}

function __RB_T_customer_status() {
    switch (!empty($_SESSION['status']) ? $_SESSION['status'] : 0) {
        case 4 : return 'Inactive';
        case 9 : return 'Payment failed';
        default: return 'Active';
    }
}

function __RB_T_customer_type() {
    return 'Gold';
}

function __RB_T_lottery_next_draw_date() {
    return date('l, F jS Y', date('N') == 5 && date('H') < '18' ? time() : strtotime('next friday'));
}

function __RB_T_lottery_end_date() {
    return 'UTC+00:00 ' . date('d.m.Y', date('N') == 5 && date('H') < '18' ? time() : strtotime('next friday')) . ' 16:00:00';
}

function __RB_T_product_name() {
    return $_SESSION['product']['name'];
}

function __RB_T_product_image() {
    return $_SESSION['product']['image'];
}

function __RB_T_product_date() {
    return $_SESSION['product']['date'];
}

function __RB_T_product_amount() {
    return $_SESSION['product']['amount'];
}

function __RB_T_transaction_next_date() {
    return !empty($_SESSION['transactions']) ? $_SESSION['transactions'][0]['date'] : 'NaN';
}

function __RB_T_minToRuntime($min) {
    return floor($min / 60) . 'H ' . (((int)$min) % 60) . 'Min';
}

function __RB_T_secToRuntime($sec) {
    $runtime = '';

    $hour = floor($sec / 3600);

    if ($hour) {
        $runtime .= $hour . ' hour';
    }

    $min = floor(($sec - $hour * 3600) / 60);

    if ($min) {
        $runtime .= ($runtime ? ', ' : '') . $min . ' min ';
    }

    $sec = floor(($sec - $hour * 3600 - $min * 60) / 60);

    if ($sec) {
        $runtime .= ($runtime ? ', ' : '') . $sec . ' sec ';
    }

    return $runtime;
}

function __RB_T_post($name) {
    if (empty($_POST[$name])) {
        if ($name == 'file_search' && !empty($_GET[$name])) {
            return htmlspecialchars($_GET[$name]);
        }

        return '';
    }

    return htmlspecialchars($_POST[$name]);
}

function __RB_T_currentLng() {
    return !empty($_SESSION['lng']) ? $_SESSION['lng'] : 'en';
}

function __RB_T_currentLngName() {
    return !empty($_SESSION['lngName']) ? $_SESSION['lngName'] : 'English';
}

function __RB_T_printPost($name) {
    return !empty($_POST[$name]) ? $_POST[$name] : '';
}

function __RB_T_copyrightInfo() {
    global $__RB_config;

    if (strtolower($__RB_config['company']['country']) == 'cyprus') {
        return '© ' . date('Y') . ' ' . $__RB_config['company']['name'] . ', ' . $__RB_config['company']['address'] . ', ' . $__RB_config['company']['zipcode'] . ' ' . $__RB_config['company']['city'] . ', ' . $__RB_config['company']['country'];
    }
    elseif (strtolower($__RB_config['company']['country']) == 'netherlands') {
        return '© ' . date('Y') . ' ' . $__RB_config['company']['name'] . ', CRN: ' . $__RB_config['company']['vat'] . ', ' . $__RB_config['company']['address'] . ', ' . $__RB_config['company']['zipcode'] . ' ' . $__RB_config['company']['city'] . ', ' . $__RB_config['company']['country'];
    }
    elseif ($__RB_config['company']['country'] == 'USA') {
        return '© ' . date('Y') . ' ' . $__RB_config['company']['name'] . ', ' . $__RB_config['company']['address'] . ', ' . $__RB_config['company']['city'] . ', ' . $__RB_config['company']['state'] . ', ' . $__RB_config['company']['country'];
    }
    elseif (strtolower($__RB_config['company']['country']) == 'united kingdom' || strtolower($__RB_config['company']['country']) == 'england') {
        return '© ' . date('Y') . ' ' . $__RB_config['company']['name'] . ', ' . $__RB_config['company']['address'] . ', ' . $__RB_config['company']['city'] . ', ' . $__RB_config['company']['zipcode'] . ', ' . $__RB_config['company']['country'];
    }

    return '© ' . date('Y') . ' ' . $__RB_config['company']['name'] . ', ' . $__RB_config['company']['address'] . ', ' . $__RB_config['company']['city'] . ', ' . $__RB_config['company']['state'] . ', ' . $__RB_config['company']['zipcode'] . ', ' . $__RB_config['company']['country'];
}

function __RB_T_companyInfo() {
    global $__RB_config;

    return
            '<span translate="no"><span class="companyName">'. $__RB_config['company']['name'] . '</span><br>' .
            (strtolower($__RB_config['company']['country']) != 'netherlands' ? '<span class="companyVat">CRN: ' . $__RB_config['company']['vat'] . '</span><br>' : '') .
            '<span class="companyAddress">'. $__RB_config['company']['address'] . '</span><br>' .
            (!in_array(strtolower($__RB_config['company']['country']), ['cyprus', 'netherlands']) ? '<span class="companyState">'. $__RB_config['company']['state'] . '</span><br>' : '').
            (in_array(strtolower($__RB_config['company']['country']), ['cyprus', 'netherlands']) ? '<span class="companyZip">'. $__RB_config['company']['zipcode'] . '</span> ' : '') . 
            '<span class="companyCity">'. $__RB_config['company']['city'] . '</span><br>' .
            (!in_array(strtolower($__RB_config['company']['country']), ['usa', 'cyprus']) ? '<span class="companyZip">'. $__RB_config['company']['zipcode'] . '</span><br>' : '').
            '<span class="companyCountry">'. $__RB_config['company']['country'] . '</span></span>';
}