<?php

$languageValidation = [
    "firstName" => [
        "name" => "Fornavn",
        "validation" => "Fornavnet er ikke gyldigt"
    ],
    "lastName" => [
        "name" => "Efternavn",
        "validation" => "Efternavnet er ikke gyldigt"
    ],
    "address" => [
        "name" => "Adresse",
        "validation" => "Adressen er ikke gyldigt"
    ],
    "postalCode" => [
        "name" => "Postnummer",
        "validation" => "Postnummeret er ikke gyldigt"
    ],
    "city" => [
        "name" => "By",
        "validation" => "Byen er ikke gyldig"
    ],
    "emailAddress" => [
        "name" => "E-mail adresse",
        "validation" => "E-mailen er ikke gyldig"
    ],
    "oldEmailAddress" => [
        "name" => "Nuværende e-mail adresse",
        "validation" => "E-mailen er ikke gyldig"
    ],
    "newEmailAddress" => [
        "name" => "Ny e-mail adresse",
        "validation" => "Ny e-mail adresse er ikke gyldig"
    ],
    "newEmailAddressRepeat" => [
        "name" => "Gentag e-mail adresse",
        "validation" => "Gentag e-mailen er ikke gyldig"
    ],
    "phoneNumber" => [
        "name" => "Tlf.nr.",
        "validation" => "Tlf.nummeret er ikke gyldigt"
    ],
    "tos" => [
        "name" => "Betingelser",
        "validation" => "Betingelserne skal accepteres",
        "missing" => "Betingelserne skal accepteres"
    ],
    "cardHolder" => [
        "name" => "Kortholder",
        "validation" => "Kortholderens navn er ikke gyldigt"
    ],
    "cardNumber" => [
        "name" => "Kortnummer",
        "validation" => "Kortnummeret er ikke gyldigt"
    ],
    "expiryDate" => [
        "name" => "Udløbsdato",
        "validation" => "Udløbsdatoen er ikke gyldig"
    ],
    "cvcNumber" => [
        "name" => "CVC-nummer",
        "validation" => "CVC-nummeret er ikke gyldigt"
    ],
    "password" => [
        "name" => "Adgangskode"
    ],
    "oldPassword" => [
        "name" => "Nuværende adgangskode"
    ],
    "newPassword" => [
        "name" => "Ny adgangskode"
    ],
    "newPasswordRepeat" => [
        "name" => "Gentag adgangskode"
    ],
];

$languageStd = [
    "missing" => "Mangler input-feltet: ",
    "validation" => "Feltet er ikke gyldigt",
    "empty" => " skal udfyldes",
    "name" => "UNKNOWN!",
    "notComplete" => "Udfyld venligst felterne korrekt"
];

$languageForm = [
    "login" => [
        "label" => [
            "emailAddress" => "E-mail adresse:",
            "password" => "Adgangskode:",
            "rememberMe" => "Husk mig"
        ],
        "submit" => "Log ind"
    ],
    "changePassword" => [
        "label" => [
            "oldPassword" => "Nuværende adgangskode:",
            "newPassword" => "Ny adgangskode:",
            "newPasswordRepeat" => "Gentag adgangskode"
        ],
        "submit" => "Skift adgangskode"
    ],
    "forgottenPassword" => [
        "label" => [
            "emailAddress" => "E-mail adresse:"
        ],
        "submit" => "Nulstil adgangskode",
        "success" => "En bekræftelsesmail er blevet tilsendt dig om, hvordan du nulstiller din adgangskode, såfremt at din e-mail adresse eksisterer i vor database."
    ],
    "changeAddress" => [
        "label" => [
            "firstName" => "Fornavn:",
            "lastName" => "Efternavn:",
            "address" => "Adresse:",
            "postalCode" => "Postnummer:",
            "city" => "By:",
            "phoneNumber" => "Tlf.nr.:"
        ],
        "submit" => "Opdater adresse"
    ],
    "changeCreditCard" => [
        "label" => [
            "cardHolder" => "Kortholder:",
            "cardNumber" => "Kortnummer:",
            "expiryDate" => "Udløbsdato:",
            "cvcNumber" => "CVC-nummer:"
        ],
        "submit" => "Skift betalingskort"
    ],
    "changeEmailAddress" => [
        "label" => [
            "oldEmailAddress" => "Nuværende e-mail adresse:",
            "newEmailAddress" => "Ny e-mail adresse:",
            "newEmailAddressRepeat" => "Gentag e-mail adresse:"
        ],
        "submit" => "Skift e-mail adresse"
    ]
];

$languageContent = [
    "logout" => [
        "loggedOut" => "Du er nu logget ud."
    ]
];

$languageError = [
	"login" => [
        "wrongLogin" => "E-mailen eller adgangskoden er forkert."
    ],
    "changePassword" => [
        "didntMatch" => "Den nye adgangskode og gentag adgangskode passer ikke sammen.",
        "oldNewSame" => "Den nuværende og nye adgangskode må ikke være den samme.",
        "oldWrong" => "Den indtastet nuværende adgangskode er forkert"
    ],
    "changeEmailAddress" => [
        "didntMatch" => "Den nye e-mail og gentag e-mail passer ikke sammen.",
        "oldNewSame" => "Den nuværende og nye e-mail adresse må ikke være den samme.",
        "oldWrong" => "Den indtastet nuværende e-mail adresse er forkert.",
        "mailInUse" => "Denne e-mail adresse er allerede i brug. Prøv venligst med en anden."
    ],
    "changeCreditCard" => [
        "invalidCreditCard" => "Betalingskortets opylysninger kunne ikke godkendes. Prøv venligst igen."
    ],
    "forgottenPassword" => [
        "wrongMail" => "En bruger med denne e-mail adresse findes ikke."
    ]
];

$languageSuccess = [
    "changeAddress" => [
        "changed" => "Adressen er nu blevet opdateret."
    ],
    "changePassword" => [
        "changed" => "Adgangskoden er nu ændret."
    ],
    "changeEmailAddress" => [
        "changed" => "E-mail adresse er nu ændret."
    ],
    "changeCreditCard" => [
        "changed" => "Betalingskortet er nu udskiftet."
    ],
    "forgottenPassword" => [
        "sent" => "En e-mail er tilsendt dig med mere information."
    ]
];

/*  Router System - language Cfg -> Page

    Menu Structure:
    pageName => ["
        "link" => Address to be displayed in the url (regex: [a-b-_0-9]+),
        "title" => Title of the pagem
        "display" => 0 - it is a navigation, but shouldn't be displayed in the menu.
                     1 - it is a navigation for logged out users
                     2 - it is a naviagion for logged in users
                     3 - it is a navigation for both logged in and out users
    "]
*/

$languageCfg = [
    "page" => [
        "forgottenPassword" => [
            "link" => "glemt-adgangskode",
            "title" => "Glemt adgangskode",
            "ro" => 1,
        ],
        "resetPassword" => [
            "link" => "nulstil-adgangskode",
            "title" => "Nulstil adgangskode",
            "display" => 0,
        ],
        "login" => [
            "link" => "log-ind",
            "title" => "Log ind",
            "display" => 1,
        ],
        "profile" => [
            "link" => "profil",
            "title" =>  "Profil",
            "display" => 2,
        ],
        "changeCreditCard" => [
            "link" => "skift-betalingskort",
            "title" => "Skift betalingskort",
            "display" => 0,
        ],
        "changeAddress" => [
            "link" => "aendre-adresse",
            "title" => "Ændre adresse",
            "display" => 2,
        ],
        "changeEmailAddress" => [
            "link" => "aendre-email-adresse",
            "title" => "Ændre e-mail adresse",
            "display" => 2,
        ],
        "changePassword" => [
            "link" => "aendre-adgangskode",
            "title" =>  "Ændre adgangskode",
            "display" => 2,
        ],
        "logout" => [
            "link" => "log-ud",
            "title" =>  "Log ud",
            "display" => 2,
        ]
    ]
];

$languagePage = &$languageCfg['page']; //Shortcut to $languageCfg['page']
